# Shopify Product Blog Generator

## Overview

This skill helps e-commerce store owners and marketers convert Shopify products into SEO-optimized blog articles. It generates product FAQ blogs, buying guides, and product-focused content that drives organic traffic.

## Usage

Invoke this skill by typing:

```
/shopify-product-blog
```

Or naturally mention product content needs like:
- "Create a blog post about my new product"
- "Generate FAQ content for my store"
- "Write a buying guide for my category"

## Features

- **SEO Optimization**: Keyword research and on-page SEO suggestions
- **FAQ Generation**: Common questions and answers based on product details
- **Buying Guides**: Comparison and selection guides
- **Product Roundups**: Category-based content creation

## Content Types

### Product FAQ Blog
Answer common questions about specific products

### Buying Guide
Help customers choose the right product

### Product Comparison
Compare similar products in your catalog

### Use Case Stories
Show products in real-world applications

### Seasonal Content
Holiday and event-specific product content

## Example Session

```
User: Create a blog post for my new wireless headphones product
Assistant: [Uses skill to generate SEO-optimized product article with FAQs]
```

## SEO Features

- Meta title and description generation
- Header structure (H1, H2, H3) optimization
- Internal linking suggestions
- Schema markup recommendations
- Keyword density analysis

## Author

AgentBiz.ai

## Version

1.0.0
